﻿Imports System.IO.IsolatedStorage

Public Class QuickNotesSettings
    Public Sub New()
        Me.Text = ""
        Me.FontSize = CDbl(Application.Current.Resources("PhoneFontSizeMediumLarge"))
    End Sub


    Public Property Text() As String
    Public Property FontSize() As Double


    Public Shared Function Load() As QuickNotesSettings
        Dim isoSettings = IsolatedStorageSettings.ApplicationSettings
        Dim settings As QuickNotesSettings = Nothing

        If Not isoSettings.TryGetValue(Of QuickNotesSettings)("settings", settings) Then
            settings = New QuickNotesSettings()
        End If

        Return settings
    End Function


    Public Sub Save()
        Dim isoSettings = IsolatedStorageSettings.ApplicationSettings
        isoSettings("settings") = Me
    End Sub
End Class

